<?php
// ============================================================
// BufferController.php
//
// Endpoints:
//   POST /api/buffer/bulk-insert  ->  bulkInsert()
//   POST /api/buffer/bulk-update  ->  bulkUpdate()
//
// Response statuses:
//   bulk-insert: INSERTED | SKIPPED | FAILED
//   bulk-update: UPDATED  | NOT_FOUND | FAILED
// ============================================================

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../models/BufferService.php';

class BufferController
{
    private BufferService $service;

    public function __construct()
    {
        $this->service = new BufferService();
    }

    // ==========================================================
    // POST /api/buffer/bulk-insert
    // ==========================================================
    public function bulkInsert(): void
    {
        $requests = $this->parseBody();
        if ($requests === null) return;

        $response = $this->service->bulkInsert($requests);
        http_response_code(200);
        echo json_encode($response);
    }

    // ==========================================================
    // POST /api/buffer/bulk-update
    // ==========================================================
    public function bulkUpdate(): void
    {
        $requests = $this->parseBody();
        if ($requests === null) return;

        $response = $this->service->bulkUpdate($requests);
        http_response_code(200);
        echo json_encode($response);
    }

    // ---- Helper: Parse JSON body ----
    private function parseBody(): ?array
    {
        $body     = file_get_contents('php://input');
        $requests = json_decode($body, true);

        if (!is_array($requests)) {
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => 'Invalid JSON body. Expected an array of lead objects.'
            ]);
            return null;
        }

        return $requests;
    }
}
