<?php
// ============================================================
// index.php - Front Controller / Router
//
// Routes:
//   POST /api/buffer/bulk-insert  ->  bulkInsert()
//   POST /api/buffer/bulk-update  ->  bulkUpdate()
// ============================================================

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/controllers/BufferController.php';

// ---- CORS Headers ----
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// ---- Parse Request URI ----
$requestUri    = $_SERVER['REQUEST_URI'] ?? '/';
$requestMethod = $_SERVER['REQUEST_METHOD'];

$path = parse_url($requestUri, PHP_URL_PATH);
$path = rtrim($path, '/');
$path = str_replace('/lead_management_v2', '', $path);

$controller = new BufferController();

// ---- Route: POST /api/buffer/bulk-insert ----
if ($requestMethod === 'POST' && $path === '/api/buffer/bulk-insert') {
    $controller->bulkInsert();
    exit;
}

// ---- Route: POST /api/buffer/bulk-update ----
if ($requestMethod === 'POST' && $path === '/api/buffer/bulk-update') {
    $controller->bulkUpdate();
    exit;
}

// ---- 404 Fallback ----
http_response_code(404);
echo json_encode(['success' => false, 'message' => 'Route not found. Available: POST /api/buffer/bulk-insert | POST /api/buffer/bulk-update']);
